# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import gc

"""
Конфиг гуникорна, который следит за состоянием mysql - инициализирует прекеш, синхронизирует базу в фоне, etc
"""


db_syncer = None


def on_starting(server):
    from travel.rasp.library.python.common23.db.switcher import SyncDbInBackground
    from travel.rasp.library.python.common23.models.precache.backend import setup_precache

    global db_syncer
    db_syncer = SyncDbInBackground()

    with db_syncer.lock:
        setup_precache(logger=server.log)


def when_ready(server):
    db_syncer.start()


def on_reload(server):
    from travel.rasp.library.python.common23.models.precache.backend import setup_precache

    with db_syncer.lock:
        setup_precache(logger=server.log)


def pre_fork(server, worker):  # XXX эти фиксы не имеют прямого отношения к mysql. может унести их в отдельный файл?
    # Закрываем соединение, чтобы не передавать воркерам копию сокета [RASPWIZARDS-175]
    from django.core.cache import cache
    cache.close()

    # собираем мусор, чтобы не оставлять его в форках
    gc.collect()
