# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.server.gunicorn import db_control
from travel.rasp.library.python.common23.server.gunicorn import gunicorn_metrics


preload_app = True
limit_request_line = 8190
worker_class = gunicorn_metrics.worker_class


def on_starting(server):
    db_control.on_starting(server)
    gunicorn_metrics.on_starting(server)


def when_ready(server):
    db_control.when_ready(server)


def on_reload(server):
    db_control.on_reload(server)


def pre_fork(server, worker):
    db_control.pre_fork(server, worker)
    gunicorn_metrics.pre_fork(server, worker)


def child_exit(server, worker):
    gunicorn_metrics.child_exit(server, worker)
