# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.library.python.gunicorn.worker_watcher import WorkersWatcher
from travel.library.python.solomon.server import SolomonMetricsServer


watcher = WorkersWatcher()
solomon = SolomonMetricsServer()

worker_class = 'travel.library.python.gunicorn.worker_watcher.workers.SyncWorker'


def on_starting(server):
    watcher.on_starting(server)

    solomon.register_gauge({'sensor': 'requests_in_work'}, watcher.get_requests_in_work_count)
    solomon.register_gauge({'sensor': 'requests_in_work_max'}, watcher.get_max_requests_in_work)
    solomon.run_in_thread()


def pre_fork(arbiter, worker):
    watcher.pre_fork(arbiter, worker)


def child_exit(server, worker):
    watcher.child_exit(server, worker)
