# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


class BaseConfigurator(object):
    def __init__(self, config):
        self.config = config

    def apply(self, config_type, settings):
        self.apply_base(settings)

        config_func = getattr(self, 'apply_{}'.format(config_type))
        config_func(settings)

        self.apply_after_all(settings)

    def apply_base(self, settings):
        pass

    def apply_stress(self, settings):
        pass

    def apply_testing(self, settings):
        pass

    def apply_development(self, settings):
        pass

    def apply_production(self, settings):
        pass

    def apply_after_all(self, settings):
        pass
