# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration.base import BaseConfigurator


SANDBOX_BINARY_STABLE = 'stable'
SANDBOX_BINARY_TESTING = 'testing'


class MiscConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        settings['BLACKBOX_URL'] = 'http://blackbox-mimino.yandex.net/blackbox'
        settings['BLACKBOX_TIMEOUT'] = None
        settings['BLACKBOX_RETRY_COUNT'] = None
        settings['PATHFINDER_CORE_URL'] = 'https://testing.pathfinder-core.rasp.yandex.net/search'

        settings['TICKET_HOST'] = 'travel-test.yandex.ru/avia'
        settings['NATIONAL_AVIA_DOMAINS'] = {
            'ru': 'travel-test.yandex.ru/avia'
        }

        settings['CURRENCY_RATES_URL'] = 'http://units-converter.yandex.net:11000/converter-rasp'
        settings['CURRENCY_RATES_TIMEOUT'] = .5  # полсекунды

        settings['FOTKI_API'] = 'https://api-fotki.yandex.ru'

        settings['FOTKI_API_INTERCITY_LOGIN'] = 'yndx-service-intercity'
        settings['INTERCITY_ORIG_IMAGE_ALBUM'] = '469176'
        settings['INTERCITY_SMALL_IMAGE_ALBUM'] = '469178'
        settings['INTERCITY_LARGE_IMAGE_ALBUM'] = '469177'
        settings['FOTKI_API_INTERCITY_PASSWORD'] = ''
        settings['FOTKI_API_INTERCITY_TOKEN'] = ''

        settings['PARTNERS_PROXY_USER'] = None
        settings['PARTNERS_PROXY_PASSWORD'] = None

        # 'abc' заглушка если секреты игнорируются
        settings['SECRET_KEY'] = get_secret('rasp-common-testing.DJANGO_SECRET_KEY', secret_stub='abc')
        settings['LOGBROKER_OAUTH_TOKEN'] = get_secret('rasp-robot-tokens-and-passwords.logbroker-oauth-token', None)
        settings['YT_TOKEN'] = None
        settings['YQL_TOKEN'] = get_secret('rasp-robot-tokens-and-passwords.yql-token')
        settings['TANKER_TOKEN'] = None
        settings['SANDBOX_TOKEN'] = None
        settings['SANDBOX_BINARY_RELEASE_TYPE'] = None
        settings['QLOUD_TOKEN'] = None

    def apply_stress(self, settings):
        settings['BLACKBOX_URL'] = 'http://pass-stress-na1.sezam.yandex.net'
        settings['BLACKBOX_TIMEOUT'] = 0.05
        settings['BLACKBOX_RETRY_COUNT'] = 1

        settings['HAS_VALID_YANDEXUID_ALWAYS_TRUE'] = True

        settings['PATHFINDER_CORE_URL'] = 'https://stress.pathfinder-core.rasp.yandex.net/search'
        settings['CURRENCY_RATES_URL'] = 'http://sas1-4329.search.yandex.net:7920/converter-rasp'

    def apply_testing(self, settings):
        settings['MEDIA_URL'] = 'https://work.admin-test.rasp.yandex-team.ru/media/'

        settings['PARTNERS_PROXY_USER'] = get_secret('rasp-common.PARTNERS_PROXY_USER')
        settings['PARTNERS_PROXY_PASSWORD'] = get_secret('rasp-common.PARTNERS_PROXY_PASSWORD')

        settings['FOTKI_API_INTERCITY_PASSWORD'] = get_secret('rasp-common-testing.FOTKI_API_INTERCITY_PASSWORD')
        settings['FOTKI_API_INTERCITY_TOKEN'] = get_secret('rasp-common-testing.FOTKI_API_INTERCITY_TOKEN')
        settings['YT_TOKEN'] = get_secret('rasp-common-testing.YT_TOKEN')
        settings['TANKER_TOKEN'] = get_secret('rasp-common-testing.TANKER_TOKEN')
        settings['SANDBOX_TOKEN'] = get_secret('rasp-common-testing.SANDBOX_TOKEN')
        settings['SANDBOX_BINARY_RELEASE_TYPE'] = SANDBOX_BINARY_TESTING
        settings['QLOUD_TOKEN'] = get_secret('rasp-common-testing.RASP_QLOUD_API_TOKEN')

    def apply_production(self, settings):
        settings['SECRET_KEY'] = get_secret('rasp-common-production.DJANGO_SECRET_KEY')
        settings['YT_TOKEN'] = get_secret('rasp-common-production.YT_TOKEN')
        settings['TANKER_TOKEN'] = get_secret('rasp-common-production.TANKER_TOKEN')

        settings['FOTKI_API_INTERCITY_PASSWORD'] = get_secret('rasp-common-production.FOTKI_API_INTERCITY_PASSWORD')
        settings['FOTKI_API_INTERCITY_TOKEN'] = get_secret('rasp-common-production.FOTKI_API_INTERCITY_TOKEN')

        settings['BLACKBOX_URL'] = 'http://blackbox.yandex.net/blackbox'

        settings['MEDIA_URL'] = '//yastat.net/s3/rasp/media/'

        settings['TICKET_HOST'] = 'travel.yandex.ru/avia'
        settings['NATIONAL_AVIA_DOMAINS'] = {
            'ru': 'travel.yandex.ru/avia',
            'tr': 'bilet.yandex.com.tr',
            'com': 'flights.yandex.com'
        }

        settings['PARTNERS_PROXY_USER'] = get_secret('rasp-common.PARTNERS_PROXY_USER')
        settings['PARTNERS_PROXY_PASSWORD'] = get_secret('rasp-common.PARTNERS_PROXY_PASSWORD')

        settings['PATHFINDER_CORE_URL'] = 'https://production.pathfinder-core.rasp.yandex.net/search'
        settings['SANDBOX_TOKEN'] = get_secret('rasp-common-production.SANDBOX_TOKEN')
        settings['SANDBOX_BINARY_RELEASE_TYPE'] = SANDBOX_BINARY_STABLE
        settings['QLOUD_TOKEN'] = get_secret('rasp-common-production.RASP_QLOUD_API_TOKEN')
