# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.settings.configuration.base import BaseConfigurator
from travel.rasp.library.python.common23.settings.configuration.mongo.default import DefaultMongoConfigurator
from travel.rasp.library.python.common23.settings.configuration.mongo.dynamic_settings import DynamicSettingsMongoConfigurator
from travel.rasp.library.python.common23.settings.configuration.mongo.platforms import PlatformsMongoConfigurator
from travel.rasp.library.python.common23.settings.configuration.mongo.suburban_events import SuburbanEventsMongoConfigurator
from travel.rasp.library.python.common23.settings.configuration.mongo.train_purchase import TrainPurchaseMongoConfigurator


class AllMongoDatabasesConfigurator(BaseConfigurator):
    CONFIGURATORS = [
        DefaultMongoConfigurator,
        DynamicSettingsMongoConfigurator,
        SuburbanEventsMongoConfigurator,
        TrainPurchaseMongoConfigurator,
        PlatformsMongoConfigurator,
    ]

    def apply_stress(self, settings):
        for configurator in self.CONFIGURATORS:
            configurator(self.config).apply_stress(settings)

    def apply_testing(self, settings):
        for configurator in self.CONFIGURATORS:
            configurator(self.config).apply_testing(settings)

    def apply_production(self, settings):
        for configurator in self.CONFIGURATORS:
            configurator(self.config).apply_production(settings)

    def apply_after_all(self, settings):
        for configurator in self.CONFIGURATORS:
            configurator(self.config).apply_after_all(settings)
