# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration.mongo.mongo_base_configurator import MongoBaseConfigurator


_FALLBACK_HOSTS = {
    'production': [
        'man-daufkn7jxanq3j9o.db.yandex.net',
        'sas-t7uj3lwfqz8fwu8v.db.yandex.net',
        'vla-h67tkfj1e8przq7d.db.yandex.net',
    ],
    'testing': [
        'sas-esnnqdabnj73w0lh.db.yandex.net',
        'vla-50ftxdybt6ao0fho.db.yandex.net',
        'man-yjk7pyxe30w074ma.db.yandex.net'
    ],
    'stress': [
        'man-lwficnzmq18olskk.db.yandex.net',
        'vla-sqiz96nfmsfdvkye.db.yandex.net',
        'sas-hgvta6d66yy1e41g.db.yandex.net'
    ]
}


class DefaultMongoConfigurator(MongoBaseConfigurator):
    def _apply_secret(self, settings, secret_alias, fallback_hosts=None):
        secret = get_secret(secret_alias)
        settings['MONGO_DATABASES']['default'] = {
            'db': 'rasp',
            'options': {
                'socketTimeoutMS': 3000,
                'connectTimeoutMS': 3000,
                'serverSelectionTimeoutMS': 3000,
                'maxIdleTimeMS': 5000
            },
            'dbaas_id': secret['DBAAS_MONGO_DEFAULT_DB_ID'],
            'user': secret['DBAAS_MONGO_DEFAULT_DB_USER'],
            'password': secret['DBAAS_MONGO_DEFAULT_DB_PASSWORD'],
            'port': self._get_port(),
        }
        self._set_fallback_hosts(settings['MONGO_DATABASES']['default'], fallback_hosts)

    def apply_stress(self, settings):
        self._apply_secret(settings, 'rasp-common-stress', fallback_hosts=_FALLBACK_HOSTS['stress'])

    def apply_testing(self, settings):
        self._apply_secret(settings, 'rasp-common-testing', fallback_hosts=_FALLBACK_HOSTS['testing'])

    def apply_production(self, settings):
        self._apply_secret(settings, 'rasp-common-production', fallback_hosts=_FALLBACK_HOSTS['production'])

    def apply_after_all(self, settings):
        self._create_no_timeout_database(settings, 'default')
