# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration.mongo.mongo_base_configurator import MongoBaseConfigurator


_FALLBACK_HOSTS = {
    'production': [
        'man-qyovo3zled2y8p8l.db.yandex.net',
        'sas-leky8l0nx0sqklmw.db.yandex.net',
        'vla-9wia5vqsq91vneiv.db.yandex.net',
    ],
    'testing': [
        'man-yr0ido2lq8oanuv9.db.yandex.net',
        'sas-wz4epv75yhnjwrnn.db.yandex.net',
        'vla-0rr0ypxfgua8gyxb.db.yandex.net',
    ],
    'stress': [
        'man-lyz01f9ot2gbvb5p.db.yandex.net',
        'sas-6o22cnvs7bjtbmdo.db.yandex.net',
        'vla-qflfee29xrhw9gsc.db.yandex.net',
    ]
}


class DynamicSettingsMongoConfigurator(MongoBaseConfigurator):
    def _apply_secret(self, settings, secret_alias, fallback_hosts=None):
        secret = get_secret(secret_alias)
        settings['MONGO_DATABASES']['dynamic_settings'] = {
            'db': 'dynamic_settings',
            'options': {
                'socketTimeoutMS': 3000,
                'connectTimeoutMS': 3000,
                'serverSelectionTimeoutMS': 3000,
                'maxIdleTimeMS': 5000
            },
            'dbaas_id': secret['DBAAS_MONGO_DYNAMIC_SETTINGS_ID'],
            'user': secret['DBAAS_MONGO_DYNAMIC_SETTINGS_USER'],
            'password': secret['DBAAS_MONGO_DYNAMIC_SETTINGS_PASSWORD'],
            'port': self._get_port(),
        }
        settings['DYNAMIC_SETTINGS_DATABASE_NAME'] = 'dynamic_settings'
        self._set_fallback_hosts(settings['MONGO_DATABASES']['dynamic_settings'], fallback_hosts)
        self._create_no_timeout_database(settings, 'dynamic_settings')

    def apply_stress(self, settings):
        self._apply_secret(settings, 'rasp-common-stress', fallback_hosts=_FALLBACK_HOSTS['stress'])

    def apply_testing(self, settings):
        self._apply_secret(settings, 'rasp-common-testing', fallback_hosts=_FALLBACK_HOSTS['testing'])

    def apply_production(self, settings):
        self._apply_secret(settings, 'rasp-common-production', fallback_hosts=_FALLBACK_HOSTS['production'])
