# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import abc
import os
from copy import deepcopy

import six

from travel.rasp.library.python.common23.settings.configuration.base import BaseConfigurator


@six.add_metaclass(abc.ABCMeta)
class MongoBaseConfigurator(BaseConfigurator):
    def _set_fallback_hosts(self, db_settings, fallback_hosts=None):
        if fallback_hosts:
            db_settings['fallback_hosts'] = fallback_hosts

    def _create_no_timeout_database(self, settings, source_name):
        destination_name = source_name + '_no_timeout'
        settings['MONGO_DATABASES'][destination_name] = deepcopy(settings['MONGO_DATABASES'][source_name])
        settings['MONGO_DATABASES'][destination_name].setdefault('options', {})['socketTimeoutMS'] = None
        settings['MONGO_DATABASES'][destination_name].setdefault('options', {})['maxIdleTimeMS'] = 100

    @staticmethod
    def _get_port():
        return int(os.getenv('RASP_MONGO_RECIPE_PORT', 27018))
