# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration.mongo.mongo_base_configurator import MongoBaseConfigurator


_FALLBACK_HOSTS = {
    'production': [
        'sas-0f8uq4g3kchmwi3i.db.yandex.net',
        'vla-h1jrs9bhj3s9xyth.db.yandex.net',
        'sas-degcwhez51qbghhy.db.yandex.net',
        'vla-dlr1k81blbucpxr6.db.yandex.net'
    ],
    'stress': [
        'sas-4049vcsf3445dr2v.db.yandex.net',
        'vla-axg8asbdw0iu84s4.db.yandex.net',
    ]
}


class PlatformsMongoConfigurator(MongoBaseConfigurator):
    """
    Хранилище динамических платформ.
    Заведено только для прода, в тестинге используется база default. См. DYNAMIC_PLATFORMS_DB_ALIAS
    https://st.yandex-team.ru/RASPFRONT-6786
    """

    def _apply_secret(self, settings, secret_alias, fallback_hosts=None):
        secret = get_secret(secret_alias)
        settings['MONGO_DATABASES']['platforms'] = {
            'db': 'platforms',
            'options': {
                'socketTimeoutMS': 2000,
                'connectTimeoutMS': 1000,
                'serverSelectionTimeoutMS': 1000,
                'maxIdleTimeMS': 3000
            },
            'dbaas_id': secret['DBAAS_MONGO_PLATFORMS_DB_ID'],
            'user': secret['DBAAS_MONGO_PLATFORMS_DB_USER'],
            'password': secret['DBAAS_MONGO_PLATFORMS_DB_PASSWORD'],
            'port': self._get_port(),
        }
        self._set_fallback_hosts(settings['MONGO_DATABASES']['platforms'], fallback_hosts)

    def apply_stress(self, settings):
        self._apply_secret(settings, 'rasp-common-stress', fallback_hosts=_FALLBACK_HOSTS['stress'])

    def apply_production(self, settings):
        self._apply_secret(settings, 'rasp-common-production', fallback_hosts=_FALLBACK_HOSTS['production'])
