# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration.mongo.mongo_base_configurator import MongoBaseConfigurator


_FALLBACK_HOSTS = {
    'production': [
        'man-j9rolti28n5tef1l.db.yandex.net',
        'sas-f43mzgjso5f791s8.db.yandex.net',
        'vla-b0kd3adk76yz5jqd.db.yandex.net',
    ],
    'testing': [
        'man-yznsd7x6wdwn1uuu.db.yandex.net',
        'sas-k3otfkhuqh0czydv.db.yandex.net',
        'vla-tv640rk5vpztd3i3.db.yandex.net',
    ],
    'stress': [
        'man-06rx9lk2u4hvz0dc.db.yandex.net',
        'sas-w7ri6x3e2n8fn0gv.db.yandex.net',
        'vla-yemaa8fixzzrb089.db.yandex.net',
    ]
}


class SuburbanEventsMongoConfigurator(MongoBaseConfigurator):
    def _apply_secret(self, settings, secret_alias, fallback_hosts=None):
        secret = get_secret(secret_alias)
        settings['MONGO_DATABASES']['suburban_events'] = {
            'db': 'suburban_events',
            'options': {
                'socketTimeoutMS': 3000,
                'connectTimeoutMS': 3000,
                'serverSelectionTimeoutMS': 3000,
                'maxIdleTimeMS': 5000
            },
            'dbaas_id': secret['DBAAS_MONGO_SUBURBAN_EVENTS_ID'],
            'user': secret['DBAAS_MONGO_SUBURBAN_EVENTS_USER'],
            'password': secret['DBAAS_MONGO_SUBURBAN_EVENTS_PASSWORD'],
            'port': self._get_port(),
        }
        settings['SUBURBAN_EVENTS_DATABASE_NAME'] = 'suburban_events'
        self._set_fallback_hosts(settings['MONGO_DATABASES']['suburban_events'], fallback_hosts)
        self._create_no_timeout_database(settings, 'suburban_events')

    def apply_stress(self, settings):
        self._apply_secret(settings, 'rasp-common-stress', fallback_hosts=_FALLBACK_HOSTS['stress'])

    def apply_testing(self, settings):
        self._apply_secret(settings, 'rasp-common-testing', fallback_hosts=_FALLBACK_HOSTS['testing'])

    def apply_production(self, settings):
        self._apply_secret(settings, 'rasp-common-production', fallback_hosts=_FALLBACK_HOSTS['production'])
