# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration.mongo.mongo_base_configurator import MongoBaseConfigurator


_FALLBACK_HOSTS = {
    'production': [
        'man-ddgojgzjenie77cc.db.yandex.net',
        'sas-4j3xo1i0tn4rsp5q.db.yandex.net',
        'vla-60nn47uiveexrlt7.db.yandex.net'
    ],
    'testing': [
        'man-ygr1d9zo56xdw4ny.db.yandex.net',
        'sas-ds40anfajd3uju2j.db.yandex.net',
        'vla-0alr3k1d8nyev7uf.db.yandex.net'
    ],
    'stress': [
        'man-1hy8rfasxbygce6m.db.yandex.net',
        'vla-qfxkkbz3xn4kqo6z.db.yandex.net',
        'sas-vl33kby43xeuq6fe.db.yandex.net'
    ]
}


class TrainPurchaseMongoConfigurator(MongoBaseConfigurator):
    def _apply_secret(self, settings, secret_alias, fallback_hosts=None):
        secret = get_secret(secret_alias)
        settings['MONGO_DATABASES']['train_purchase'] = {
            'db': 'train_purchase',
            'options': {
                'socketTimeoutMS': 4000,
            },
            'dbaas_id': secret['DBAAS_MONGO_TRAIN_PURCHASE_ID'],
            'user': secret['DBAAS_MONGO_TRAIN_PURCHASE_USER'],
            'password': secret['DBAAS_MONGO_TRAIN_PURCHASE_PASSWORD'],
            'port': self._get_port(),
        }
        self._set_fallback_hosts(settings['MONGO_DATABASES']['train_purchase'], fallback_hosts)

    def apply_stress(self, settings):
        self._apply_secret(settings, 'rasp-common-stress', fallback_hosts=_FALLBACK_HOSTS['stress'])

    def apply_testing(self, settings):
        self._apply_secret(settings, 'rasp-common-testing', fallback_hosts=_FALLBACK_HOSTS['testing'])

    def apply_production(self, settings):
        self._apply_secret(settings, 'rasp-common-production', fallback_hosts=_FALLBACK_HOSTS['production'])
