# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration.base import BaseConfigurator
from travel.rasp.library.python.common23.settings.utils import apply_switch_workflow, get_fallback_conf_from_str


class MysqlConfigurator(BaseConfigurator):
    def apply_stress(self, settings):
        secret = get_secret('rasp-common-stress')
        mysql_main_user = secret['MYSQL_MDB_MAIN_USER']
        mysql_main_password = secret['MYSQL_MDB_MAIN_PASSWORD']

        mysql_maintenance_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAINTENANCE_FALLBACK'))
        mysql_main0_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAIN0_FALLBACK'))
        mysql_main1_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAIN1_FALLBACK'))

        apply_switch_workflow(
            settings,
            maint_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAINTENANCE_CLUSTER_ID'],
                    'FALLBACK': mysql_maintenance_fallback,
                }

            },
            main0_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAIN0_CLUSTER_ID'],
                    'FALLBACK': mysql_main0_fallback,
                }
            },
            main1_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAIN1_CLUSTER_ID'],
                    'FALLBACK': mysql_main1_fallback,
                }

            },
        )

    def apply_testing(self, settings):
        secret = get_secret('rasp-common-testing')
        mysql_main_user = secret['MYSQL_MDB_MAIN_USER']
        mysql_main_password = secret['MYSQL_MDB_MAIN_PASSWORD']

        mysql_maintenance_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAINTENANCE_FALLBACK'))
        mysql_main0_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAIN0_FALLBACK'))
        mysql_main1_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAIN1_FALLBACK'))

        apply_switch_workflow(
            settings,
            maint_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAINTENANCE_CLUSTER_ID'],
                    'FALLBACK': mysql_maintenance_fallback,
                }

            },
            main0_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAIN0_CLUSTER_ID'],
                    'FALLBACK': mysql_main0_fallback,

                }
            },
            main1_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAIN1_CLUSTER_ID'],
                    'FALLBACK': mysql_main1_fallback,
                }

            },
        )

    def apply_development(self, settings):
        settings['DATABASES']['default']['USER'] = 'rasp'
        settings['DATABASES']['default']['PASSWORD'] = 'rasp'
        settings['DATABASES']['default']['NAME'] = 'rasp'
        settings['DATABASES']['default']['HOST'] = 'localhost'
        settings['TEST_DB_NAME'] = 'rasp_test'

    def apply_production(self, settings):
        secret = get_secret('rasp-common-production')
        mysql_main_user = secret['MYSQL_MDB_MAIN_USER']
        mysql_main_password = secret['MYSQL_MDB_MAIN_PASSWORD']

        mysql_maintenance_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAINTENANCE_FALLBACK'))
        mysql_main0_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAIN0_FALLBACK'))
        mysql_main1_fallback = get_fallback_conf_from_str(secret.get('MYSQL_MDB_MAIN1_FALLBACK'))

        apply_switch_workflow(
            settings,
            maint_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAINTENANCE_CLUSTER_ID'],
                    'FALLBACK': mysql_maintenance_fallback,
                },
            },
            main0_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAIN0_CLUSTER_ID'],
                    'FALLBACK': mysql_main0_fallback,
                },
            },
            main1_conf={
                'USER': mysql_main_user,
                'PASSWORD': mysql_main_password,
                'CLUSTER': {
                    'CLUSTER_ID': secret['MYSQL_MDB_MAIN1_CLUSTER_ID'],
                    'FALLBACK': mysql_main1_fallback,
                },
            },
        )
