# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration.base import BaseConfigurator


class PartnersConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        settings['UFS_TERMINAL'] = 'YAONLINE_TEST_EMUL'
        settings['UFS_USER'] = 'Yaonline'
        settings['UFS_HOST'] = 'ufs-online.ru'
        settings['UFS_TRAINLIST'] = '/webservices/Railway/Rest/Railway.svc/TrainList'
        settings['UFS_CARSLISTEX'] = '/webservices/Railway/Rest/Railway.svc/CarListEx'
        settings['UFS_SSL'] = True
        settings['UFS_PASSWORD'] = get_secret('rasp-common-testing.UFS_PASSWORD')

    def apply_stress(self, settings):
        settings['UFS_HOST'] = None

    def apply_production(self, settings):
        settings['UFS_USER'] = 'YandexOOO'
        settings['UFS_TERMINAL'] = 'YANDEXOOO_kassa'
        settings['UFS_PASSWORD'] = get_secret('rasp-common-production.UFS_PASSWORD')
