# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
from collections import namedtuple

DATABASES = {
    'default': {
        'ENGINE': 'travel.rasp.library.python.common23.db.backends.mysql',
        'HOST': None,
        'PORT': int(os.getenv('TRAVEL_MYSQL_RECIPE_PORT', '3306'))
    },
}

# switch workflow settings
WORK_DB = 'work_db'
SERVICE_DB = 'service_db'

MAINTENANCE_DB = 'maintenance_db'
MAINTENANCE_DB_ENABLED = False
MAINTENANCE_DB_CRITICAL = False

DbInstance = namedtuple('DbInstance', ['role', 'code', 'title'])

WorkInstance = DbInstance(WORK_DB, 'work', u'боевой')
ServiceInstance = DbInstance(SERVICE_DB, 'service', u'сервисный')

AVAILABLE_ROLES = [WORK_DB, SERVICE_DB]
INSTANCE_ROLE = WorkInstance


# other settings
MYSQL_CONNECT_TIMEOUT = 1
MYSQL_READ_TIMEOUT = 60
MYSQL_WRITE_TIMEOUT = 3

PRECACHE_USE_PROXY_SLOTS = False

CHECK_DB_IN_PING = True
PING_MYSQL_BEFORE_EACH_REQUEST = False

REPLICA_STATE_CACHE = 'replica_set'

CLUSTER_INFO_CACHE_ENABLED = True
CLUSTER_INFO_CACHE_TIME = 60 * 3  # seconds

MONGO_DATABASES = {
    'default': {
        'db': 'rasp',
        'options': {
            'socketTimeoutMS': 3000,
            'maxIdleTimeMS': 5000,
        },
    },
    'train_purchase': {
        'db': 'train_purchase',
        'options': {
            'socketTimeoutMS': 3000,
        },
    },
}

DYNAMIC_SETTINGS_DATABASE_NAME = 'default'
LOCK_DATABASE_NAME = 'default'
SUBURBAN_EVENTS_DATABASE_NAME = 'default'
