# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import os
from datetime import timedelta

SEND_MAIL_TO_PARTNERS = False
NEED_TO_PRECALC_WIZARD_DATA = True
TEST_WIZARD = True

# WSDL агенты
WSDL_PATH = "/production/yandex-ws/"
# WSDL_PATH = "/yandex-ws/"    # Переопределить в localsettings

# Особенности этого проекта. Магические цифры и фразы.
DOMAIN_NAME = "rasp.yandex.ru"
# Если не указан берется просто DOMAIN_NAME
ADMIN_DOMAIN_NAME = None

# Специальные адреса
AGENT_MAIL_LIST = []

# Страны, для которых показывается табло станций и городов
OUR_COUNTRIES = [
    225,  # Россия
    187,  # Украина
    149,  # Беларусь
    159,  # Казахстан
    208,  # Молдова
    117,  # Литва
    206,  # Латвия
    171,  # Узбекистан
    207,  # Киргизия
    168,  # Армения
    21619,  # Абхазия
    983,  # Турция
]

SNG_COUNTRIES = [
    225,  # Россия
    187,  # Украина
    149,  # Беларусь
    159,  # Казахстан
    208,  # Молдова
    117,  # Литва
    206,  # Латвия
    171,  # Узбекистан
    207,  # Киргизия
    168,  # Армения
    21619,  # Абхазия
]

LANG_COUNTRY_MAP = {
    'ru': 225,
    'tr': 983,
    'uk': 187,
    'be': 149,
    'kk': 159,
}

NATIONAL_VERSION_COUNTRY_MAP = {
    'ru': 225,
    'tr': 983,
    'ua': 187
}

# виды транспорта, которые нужно показывать в форме поиска и колдунщиках
NATIONAL_VERSION_TRANSPORTS = {
    '*': [
        'plane',
        'train',
        'suburban',
        'bus',
    ],

    # в турецкой версии ищем паромы (RASP-14026), но не ищем электрички (RASP-12338)
    'tr': [
        'bus',
        'plane',
        'train',
        'water',
    ]
}

LOCAL_KUBR = {
    'ru': (159, 187, 149, 225),
    'ua': (159, 187, 149, 225),  # В коде по умолчанию использовался ru
    'tr': (983,)
}

NATIONAL_CURRENCIES = {
    'ru': 'RUR',
    'ua': 'UAH',
    'tr': 'TRY',
}

MOSCOW_GEO_ID = 213
RUSSIA_GEO_ID = 225

KIEV_GEO_ID = 143
UKRAINE_GEO_ID = 187

ISTANBUL_GEO_ID = 11508
TURKEY_GEO_ID = 983


# Город по умолчанию для регионального домена. Если для регионального домена не определен город по умолчанию, то
# используется столица страны регионального домена
DEFAULT_CITIES = {
    'tr': 11508  # Стамбул
}

WEEK_DAYS = {0: u'понедельник',
             1: u'вторник',
             2: u'среда',
             3: u'четверг',
             4: u'пятница',
             5: u'суббота',
             6: u'воскресенье'}

MONTHS = {1: u'января',
          2: u'февраля',
          3: u'марта',
          4: u'апреля',
          5: u'мая',
          6: u'июня',
          7: u'июля',
          8: u'августа',
          9: u'сентября',
          10: u'октября',
          11: u'ноября',
          12: u'декабря'}

TRANSPORT_STATUSES = {'wait': u'ожидается',
                      'late': u'задержан',
                      'departure': u'отправлен',
                      'arrive': u'прибыл',
                      'cancelled': u'отменён',
                      'unknown': u'неизвестен',
                      'nodata': u'нет данных',
                      }

TRANSPORT_STATUSES_DEP = {'wait': u'ожидается',
                          'late': u'задерживается',
                          'departure': u'отправлен',
                          'arrive': u'прибыл',
                          'cancelled': u'отменён',
                          'unknown': u'неизвестен',
                          'rasch': u'отправлен',
                          'nodata': u'нет данных'
                          }

TRANSPORT_STATUSES_ARR = {'wait': u'ожидается',
                          'late': u'опаздывает',
                          'departure': u'отправлен',
                          'arrive': u'прибыл',
                          'cancelled': u'отменён',
                          'unknown': u'неизвестен',
                          'rasch': u'прибыл',
                          'nodata': u'нет данных'
                          }

# на сколько дней назад смотреть рейсы, для www.forms.clear_dates
DAYS_TO_PAST = 30
MASK_SPLITTER_DAYS_TO_FUTURE = 330

# Не показываем в расписании дни вне такого диапазона дат
SEARCH_DAYS_TO_PAST = 14  # Первый день = сегодня - 14
DAYS_TO_FUTURE = 300

# Количество строк в саджестах
SUGGESTS_LIMIT = 10

# для вывода в табло:
SEE_MINUTES_FUTURE = 60 * 12
SEE_MINUTES_PAST = 30
DEFAULT_TABLO_ORDER_BY = 'number'
DEFAULT_TABLO_LIMIT = 30
INDEX_TABLO_LIMIT = 15
DEFAULT_TABLO_ALL_LIMIT = 100
ALLOWABLE_DELAY = timedelta(minutes=30)
SWITCH_STATUS_AFTER = timedelta(minutes=15)
MIN_TABLO_AMOUNT = 10  # Меньше этого количества рейсов в табло оно будет рисоваться на весь день [RASP-4574]

# Поиск соседних дат при неудачном поиске на сегодня
SEARCH_EARLIER = 7
SEARCH_LATER = 7

AGENT_LIMIT_DAYS_FORWARD = 90
BUS_LIMIT_DAYS_FORWARD = 367

# Количество городов в поиске до страны
CITIES_IN_COUNTRY_SEARCH = 10

DEPARTURE_NEXT_DAY_HOUR = 4
DEPARTURE_TIME_INT_BEFORE_NOW = 4

# Количество найденных нитей в поиске рейсов, после которого иностранные самолеты показываются отдельно
THREADS_IN_THREAD_SEARCH = 10

# Максимальная длина подсказок в поисковой форме RASP-2336
MAX_LENGTH = 25

# Погода
WEATHER_ICAO_URL = "http://export.yandex.ru/weather-ng/rasp/%s.xml"  # Погода в аэропорте
# Сервис Я.Погода для региональных доменов
WEATHER_URL = {
    'ru': "pogoda.yandex.ru",
    'ua': "pogoda.yandex.ua",
    'com.tr': "hava.yandex.com.tr",
    'by': 'pogoda.yandex.by',
    'kz': 'pogoda.yandex.kz'
}

WEATHER_DEFAULT_URL = WEATHER_URL['ru']

# Билеты
SEATS_FETCH_ENABLED = True
SEATS_IN_PAST_DAY = 0  # Количество дней, за которые ищем билеты в прошлом

# Новости аэропортов
NEWS_COUNT = 5
NEWS_DOMODEDOVO_URL = "http://www.domodedovo.ru/addins/XMLnews/XML_DMD_News.xml?lang=ru&from=%s&to=%s&first=1"

# Определение города по ip
GET_CITY_BY_IP = 'http://geobase.yandex.ru/ip.xml?ip=%s'

# Баннерная система
BANNER_URL = "http://bs.yandex.ru/page/%s"
BANNER_HTTP_TIMEOUT = 0.3

QUICK_HTTP_TIMEOUT = .1

# Таймаут при получении внешних данных, например геобазы
HTTP_TIMEOUT = 3
SUGGEST_TIMEOUT = 3
TABLO_IMPORT_TIMEOUT = 10.
SCHEDULE_IMPORT_TIMEOUT = 600  # 10 минут

INSERT_LIMIT = 1000

HIDE_DIRECTIONS_CITIES_IDS = {
    22339,  # Вековка
    10782,  # Вязьма
}

ROUTEMAP_ZONES_IDS = {
    1,  # Москва
    2,  # Питер
    6,  # Калиниград
}

AIRPLANES_PIXEL_STEP = 50
AIRPLANES_MAX_ZOOM = 17
AIRPLANES_SIEVE_THRESHOLD = 100

LOG_LEVEL = logging.INFO
TABLO_LOG_LEVEL = logging.INFO

YMAPS_KEYS = [
    ('rasp.yandex.ru', "AP2ObEkBAAAAjdeCSgMAhfPncCAZ8KHZF46T7J3FziI_8b0AAAAAAAAAAACorwopYklBkdfT19psA0KlLBEpGQ=="),
    ('rasp.yandex.ua', "AEs4FksBAAAAho2vNAMAf13km2qi586ZJW424ZSeoH7jWaIAAAAAAAAAAADZIZQl5nROaQSF1CtqSjPnQnpYrA=="),
    ('rasp.yandex.kz', "AHM4FksBAAAAL48uHwMA5emP7eE4IG5JJFYK1827e4xfcVgAAAAAAAAAAAB2ClyYJWe8SaVwPf_EWQdgH5B8vw=="),
    ('rasp.yandex.by', "ABP4E04BAAAAxd_7CwMArnXB5Iaprhj7NH2U3-x8w3EphnQAAAAAAAAAAADKPeL9K77a3KXX4XsHUNxCsJGGHw=="),
    ('rasp.yandex.com.tr', "AMgddVEBAAAAq-LiPQQAreiSEhwMnoqw44a-5OTsp_oTfyMAAAAAAAAAAACS2sOfk8BxYrVCdlS-DAPrYZWRSw=="),

    ('rasp.dev.yandex.ru', "ADQedVEBAAAA6du3WAQAUR-d7MaRAJJW3-dtfOprHTrI6tIAAAAAAAAAAAAW8e1JziyR40N9EnI0V-wLEZdeyg=="),

    ('localhost.yandex.ru', "ANAzhk4BAAAAoKDxMQMApjBYcQ11TKSyxL87oTsm7OpDUQUAAAAAAAAAAABbRSqttKK9yGzquSwKfYFTK5mazw=="),

    # Legacy
    ('dev.yandex.ru', "ALz_ykoBAAAA5JXeewMADYcTaiqRd2HuEaf9NdU0XoWKaNUAAAAAAAAAAACRigIEszJoydHbjkMre9zy3JkgCA=="),
    ('raspadmin.yandex.ru', "AEp5zEoBAAAAfL_cJgMAUSHv-GWok27r4hnjZuuG9upgDlMAAAAAAAAAAACMS8LL7CME6VCRRfPe7cjnxBX0mQ=="),

]

YMAPS_KEY = None

YMAPS_MODULES = ['traffic']

YMAPS_API = "http://api-maps.yandex.ru/1.1/index.xml"


INTERCITY_IMAGE_SIZE_ALBUMS = {
    'orig': '469176',
    '1140x772': '470360',
    '1080x579': '470361',
    '720x386': '470362',
    '540x290': '470363',
    '360x193': '470364',
    '164x164': '470365',
    '123x123': '470366',
    '82x82': '470367',
    '62x62': '470368',
    '41x41': '470369'
}

# Конфиги для RSYNC
RSYNC_CONFIGS = {}
SYNC_WITH_SERP = False
# ===============================================================================
# Пример
# claster_list = []
# RSYNC_CONFIGS = {
#    'pythonbp': (
#        [["/var/lib/yandex-rasp/rasp/www/db/scripts/export/", "rasp-export"],
#         ["/var/lib/yandex-rasp/rasp/www/db/scripts/export2/", "rasp-export2"]],
#        ["host1", "host2"]
#    )
# }
# Команды для рсинка
# rsync -avz --timeout=3000 --delete-after /var/lib/yandex-rasp/rasp/www/db/scripts/export/ rsync://host1/rasp-export
# rsync -avz --timeout=3000 --delete-after /var/lib/yandex-rasp/rasp/www/db/scripts/export/ rsync://host2/rasp-export
# rsync -avz --timeout=3000 --delete-after /var/lib/yandex-rasp/rasp/www/db/scripts/export2/ rsync://host1/rasp-export2
# rsync -avz --timeout=3000 --delete-after /var/lib/yandex-rasp/rasp/www/db/scripts/export2/ rsync://host2/rasp-export2
# ===============================================================================

MAX_DIFF_FOR_GLUE = 180

# Счетчики (RASP-5806)
COUNTERS = {1: 70142, 2: 70141, 3: 70881, 4: 72126, 5: 72126, 6: 70208}
# Счетчики для смешанной выдачи
MORE_COUNTERS = {1: 70889, 2: 70890, 3: 70892, 4: 72127, 5: 72127, 6: 70891}

# FIXME: Везде сделать замену на эту переменную
AVIAROUTE_NUMBER_DELIMITER = u" "

# Пары аэропорт - вокзал для аэроэкспрессов
AEROEXPRESSES = {9600215: 2000007,  # Внуково
                 9600216: 2000005,  # Домодедово
                 9881841: 2000006,  # Шереметьево
                 9600370: 9607404,  # Кольцово
                 9623592: 9618228}  # Вильнюс
AEROEXPRESSES.update({station_to: station_from for station_from, station_to in AEROEXPRESSES.items()})

UNITTEST = False

SCRIPT_WARNING_ACTION = 'ignore'

# RASP-8863
SUPPLIERS_CODES_SHOW_NUMBER = ['mta']

SHOW_TRANSPORTFILTER_HINT = True

TICKET_ORDER_LINK = "http://clck.yandex.ru/redir/dtype=stred/pid=168/cid=70831/*http://%s/order/?showCheaper=t&%s"
TICKET_VARIANTS_LINK = "http://%s/variants/?%s"

ORDER_BILLING_ENABLED = True

MTA_PROMO_STATIONS = [
    (9633000, u'Москва (автовокзал)'),
    (9744879, u'Москва (м.  Алтуфьево)'),
    (9744801, u'Москва (м. Бульвар Дмитрия Донского)'),
    (9744855, u'Москва (м. ВДНХ)'),
    (9744751, u'Москва (м. Выхино)'),
    (9744710, u'Москва (м. Домодедовская)'),
    (9744806, u'Москва (м. Кантемировская)'),
    (9744762, u'Москва (м. Киевская)'),
    (9744726, u'Москва (м. Кузьминки)'),
    (9744744, u'Москва (м. Кунцевская)'),
    (9744758, u'Москва (м. Медведково)'),
    (9744709, u'Москва (м. Молодёжнaя)'),
    (9744828, u'Москва (м. Новогиреево)'),
    (9744836, u'Москва (м. Парк Победы)'),
    (9744849, u'Москва (м. Партизанская)'),
    (9744765, u'Москва (м. Планерная)'),
    (9744859, u'Москва (м. Речной вокзал)'),
    (9744884, u'Москва (м. Савёловская)'),
    (9744858, u'Москва (м. Сходненская)'),
    (9744794, u'Москва (м. Тёплый Стан)'),
    (9744755, u'Москва (м. Тушинская)'),
    (9744862, u'Москва (м. Щёлковская)'),
    (9744735, u'Москва (м. Щукинская)'),
    (9744733, u'Москва (м. Юго-Западная)'),
    (9744864, u'Москва (м. Южная)'),
    (9740560, u'Апрелевка'),
    (9741560, u'Балашиха (а/ст Южная)'),
    (9737892, u'Барыбино'),
    (9740940, u'Бронницы'),
    (9743242, u'Верея'),
    (9737840, u'Видное (ст.Расторгуево)'),
    (9741897, u'Волоколамск'),
    (9744205, u'Воскресенск'),
    (9741939, u'Голицыно'),
    (9735572, u'Дедовск'),
    (9738564, u'Дмитров'),
    (9737975, u'Дмитровский Погост'),
    (9742558, u'Долгопрудный'),
    (9742354, u'Домодедово'),
    (9743839, u'Дорохово'),
    (9739655, u'Дубна (Большая Волга)'),
    (9742494, u'Егорьевск'),
    (9739602, u'Железнодорожный'),
    (9736555, u'Жуковский (ст.Отдых)'),
    (9742951, u'Зарайск'),
    (9735710, u'Звенигород (ж-д станция)'),
    (9743154, u'Истра (а/ст Новый Иерусалим)'),
    (9738009, u'Кашира'),
    (9740542, u'Климовск'),
    (9735248, u'Клин'),
    (9742674, u'Коломна (а/ст Старая Коломна)'),
    (9742697, u'Коломна (Голутвин)'),
    (9746049, u'Королёв (ст.Болшево)'),
    (9738413, u'Красноармейск'),
    (9736734, u'Краснознаменск'),
    (9738268, u'Кубинка'),
    (9745015, u'Купавна (Акрихин)'),
    (9735309, u'Куровское'),
    (9743342, u'Лобня'),
    (9738934, u'Лотошино'),
    (9735170, u'Луховицы'),
    (9737563, u'Лыткарино'),
    (9743574, u'Люберцы'),
    (9735506, u'Малино'),
    (9735354, u'Менделеево'),
    (9741740, u'Михнево'),
    (9742980, u'Можайск'),
    (9740702, u'Мытищи'),
    (9743187, u'Наро-Фоминск'),
    (9735362, u'Нахабино'),
    (9742158, u'Ногинск'),
    (9744055, u'Одинцово'),
    (9741440, u'Озёры'),
    (9736151, u'Орехово-Зуево'),
    (9742316, u'Павловский Посад'),
    (9741366, u'Подольск'),
    (9739782, u'Протвино'),
    (9735795, u'Пушкино'),
    (9739772, u'Пущино'),
    (9736892, u'Раменское'),
    (9744672, u'Рошаль'),
    (9743263, u'Руза'),
    (9742908, u'Сергиев Посад'),
    (9736832, u'Серебряные Пруды'),
    (9742814, u'Серпухов'),
    (9741758, u'Солнечногорск'),
    (9743113, u'Ступино'),
    (9737453, u'Талдом'),
    (9739796, u'Троицк'),
    (9735586, u'Тучково'),
    (9739698, u'Фрязино'),
    (9737159, u'Фряново'),
    (9743035, u'Химки'),
    (9739477, u'Черноголовка'),
    (9739631, u'Чехов'),
    (9744955, u'Шатура'),
    (9741042, u'Шаховская'),
    (9735623, u'Электрогорск'),
    (9745893, u'Электросталь'),
]

CHARTER_PARTNERS = ['charterbilet', 'clickavia', 'chabooka', 'aviaoperator']

GEOCODER_SERVICE_URL = 'http://geocode-maps.yandex.ru/1.x/'
GEOCODER_SERVICE_TIMEOUT = 3

INTERVAL_RTHREAD_TYPE_ID = 12

ADMIN_COUNTRY_YMAPLANGUAGE_MAP = {
    'RU': 'ru-RU',
    'TR': 'tr-TR',
    'UA': 'uk-UA',
}

TOO_MUCH_STATIONS = 500

SPECIAL_OFFERS_TRAVEL_URL = 'http://go.poedem.ru/?t=poedem&f=xml&a=special_offers&date='

SPACE_RASPADMIN_SHARE = 'space.rasp.yandex.net::raspadmin'

POPULAR_DIRECTIONS_IMPORT_PROXY = 'smith.yt.yandex.net'

# Mandatory access control
ORDER_DATA_MAC_FIELDS = [
    'url',
    'tariff',
    'partner',
    'show_id',
    'lang',
    'national',
]

# https://wiki.yandex-team.ru/security/ssl/sslclientfix/#vpython
REQUESTS_CA_BUNDLE = os.environ.setdefault('REQUESTS_CA_BUNDLE', '/etc/ssl/certs/ca-certificates.crt')
INTERNAL_ROOT_CERT = os.environ.setdefault('INTERNAL_ROOT_CERT', '/etc/ssl/certs/YandexInternalRootCA.pem')
