# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import datetime
import os
import socket

from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.settings.utils import get_cache_config


ENVIRONMENT = 'production'

EMAIL_HOST = 'localhost'
EMAIL_SUBJECT_PREFIX = '[Django-rasp@%s] ' % socket.gethostname()
DEFAULT_FROM_EMAIL = 'rasp-tech@yandex-team.ru'
SERVER_EMAIL = 'Rasp at %s <rasp-tech@yandex-team.ru>' % socket.gethostname()

DEBUG = False
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'debug': False
        },
    },
]

ORDER_DEBUG = False
TIMING = False

DEBUG_PROPAGATE_EXCEPTIONS = False

DEBUG_BEMJSON = False

SHOW_TRANSFER_PRICES = False

try:
    import pwd
    current_user = ('Current User', '%s@yandex-team.ru' % pwd.getpwuid(os.getuid())[0])
except Exception:
    username = os.environ.get('USERNAME', os.environ.get('LOGNAME'))
    if username:
        current_user = ('Current User', '%s@yandex-team.ru' % username)
    else:
        current_user = ('Current User', 'none')

CURRENT_USER_NAME = current_user[1]

TESTERS = MANAGERS = ADMINS = (current_user, )
DATACHANGE_RCPNTS = PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
EXPERSS_SUBST_RCPNTS = UNKNOWN_CODES_RCPNTS = RASP_FREE_STATIONS_RCPNTS = ADMINS

ERRORS_RECIPIENTS = [current_user[1]]

THREAD_SHARED_CONNECTION = False

BILLING_HOST = 'mbi1ft.yandex.ru'  # хост биллинга
BILLING_PORT = 34861             # порт
BILLING_SERVICE_ID = 114         # номер нашего сервиса в биллинге

CACHES = {
    'default': get_cache_config(['localhost']),
}

FORCE_SCRIPT_NAME = ""

# Local time zone for this installation. Choices can be found here:
# http://www.postgresql.org/docs/8.1/static/datetime-keywords.html#DATETIME-TIMEZONE-SET-TABLE
# although not all variations may be possible on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'

# Время сервера относительно Москвы
TIME_ZONE_HOURS = 0

SITE_ID = 1
TURKISH_SITE_ID = 2
TRAINS_SITE_RU = 'trains.yandex.ru'
TRAINS_SITES = [TRAINS_SITE_RU, 'trains.yandex.by', 'trains.yandex.kz', 'trains.yandex.ua']

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Для нормальной работы админки
USE_L10N = True

DEFAULT_FILE_STORAGE = "travel.rasp.library.python.common23.models.fields.storage.TransliteratingFileSystemStorage"

ROOT_URLCONF = 'urls'

COMMON_CONTRIB_APPS = [
    'django.contrib.auth',
    'django.contrib.contenttypes',
]

COMMON_INSTALLED_APPS_BASE = [
    'travel.rasp.library.python.common23.db.mongo',
    'travel.rasp.library.python.common23.models.www',
    'travel.rasp.library.python.common23.models.tariffs',
    'travel.rasp.library.python.common23.models.texts',
    'travel.rasp.library.python.common23.models.currency',
    'travel.rasp.library.python.common23.models.transport',
    'travel.rasp.library.python.common23.models.core',
]


# None, т.е. по умолчанию закешированные результаты
# разных запросов хранятся в памяти вечно (см. /utils/cursors/..)
DEF_MYSQL_REQUEST_EXPIRE_TIME = None

LOGIN_URL = '/admin/'

GEOBASE_DATA_PATH = "/var/cache/geobase/geodata4.bin"

PKG_VERSION = datetime.datetime.today().strftime('dev.%Y%m%d%H%M%S')

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
STATIC_URL = '/static/'

# Динамический префикс ключей мемкеша.
# Может меняться по ходу работы приложения (напр, после пересчета или переключения баз)
CACHEROOT = '/yandex/rasp-service/%s/' % PKG_VERSION

RSYNC = '/usr/bin/rsync'

PATHFINDER_TIMEOUT = .5

FILE_UPLOAD_PERMISSIONS = int('0644', 8)

MAPPING_SERVER_EXPIRE = 20  # минут
MAPPING_CLIENT_EXPIRE = 5  # минут

LANGUAGE_COOKIE_NAME = 'lang'

DEBUG_I18N = False

DISABLE_YAUTH = False
DISABLE_PHD = False

MORDA_HOSTS = ['localhost']

MAIL_REPORTS_INTERVAL = 600

TANKER_KEYSETS = {}

XGETTEXT_KEYSETS = {
    'common': {
        'filename': 'common/xgettext/keyset.json',
        'dirs': [
            'common/models',
            'common/utils',
            'common/views',
        ]
    }
}

# Для загрузки кейсетов
# Сразу грузим побольше языков, т.к. в дальнейшем будем на них переводить
XGETTEXT_LANGUAGES = ['en', 'ru', 'uk', 'be', 'tt', 'kk', 'tr']

# (path, prefix, blocks)
XGETTEXT_BEM_BLOCKS = []

# Настройки языков расписаний. Ставит в соответствие домену основной язык приложения (используемый по умолчанию)
# и список языков доступных для смены
DOMAIN_LANGUAGE_MAP = {
    'ru': ('ru', ['ru']),
    'tr': ('tr', ['tr']),
    'ua': ('uk', ['uk', 'ru']),
    'by': ('ru', ['ru']),
    'kz': ('ru', ['ru']),
    'uz': ('ru', ['ru']),
}

DOMAIN_TO_NATIONAL_VERSION = {
    'ru': 'ru',
    'ua': 'ua',
    'by': 'ru',
    'kz': 'ru',
    'uz': 'ru',
    'tr': 'tr',
}

DOMAIN_CURRENCY = {
    'ru': 'RUR',
    'by': 'BYN',
    'kz': 'KZT',
    'uz': 'RUR',
    'ua': 'UAH',
    'com.tr': 'TRY',
}

TLD_TO_GEO_ID = {
    'ru': 225,
    'com.tr': 983,
    'ua': 187,
    'by': 149,
    'kz': 159,
    'uz': 171
}

NATIONAL_VERSION_TO_METRIKA = {
    'ru': 99704,
    'tr': 21395248,
    'ua': 23220169,
}

NATIONAL_VERSION_DEFAULT_SEARCH_CITIES = {
    'ru': (213, 2),  # Москва - Питер
    'tr': (11508, 11503),  # Стамбул - Анкара
    'ua': (143, 144),  # Киев - Львов
}

# Список root domains на которых показывается Яндекс.Директ
DIRECT_DOMAINS = ['ru', 'ua', 'by', 'kz', 'uz']

MODEL_LANGUAGES = ['ru', 'en', 'tr', 'uk']  # Добавлен английский, fallback для турецких названий

SUGGEST_LANGUAGES = ['ru', 'tr', 'uk', 'en']

SUGGEST_URL = 'https://suggest.rasp.yandex.net/'

# Языки для которых у нас есть отображение, возможно стоит
# объединить с DOMAIN_LANGUAGE_MAP, FRONTEND_LANGUAGES
FRONTEND_LANGUAGES = ['ru', 'tr', 'uk']

LANGUAGES = [
    ('ru', _(u'Русский')),
    ('be', _(u'Белорусский')),
    ('kk', _(u'Казахский')),
    ('tt', _(u'Татарский')),
    ('uk', _(u'Украинский')),
    ('en', _(u'Английский')),
    ('tr', _(u'Турецкий'))
]

LANGUAGE_FALLBACKS = {
    'tr': ['en'],
    'uk': ['ru'],
}

LANGUAGE_CASE_FALLBACKS = {
    ('uk', 'genitive'): [('ru', 'genitive')],
}

# Джанговские настройки для языков
# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
# http://blogs.law.harvard.edu/tech/stories/storyReader$15
LANGUAGE_CODE = 'ru'

BASE_LANGUAGE = 'ru'

WIZARD_MODE = False

CLEAN_TMP = True

TIME_CORRECTION_URL = '/time/correction/'

LOG_COLLECT_RESULTS = False

PROJECT_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), '../..'))

try:
    SUBMODULE_STATUS = open(
        os.path.join(PROJECT_PATH, 'submodule-status')
    ).read()
except IOError:
    SUBMODULE_STATUS = 'no submodule-status'

SECRET_SALT = 'b1818c0846d2bb22b30e17b6dbd678be'

HAS_VALID_YANDEXUID_ALWAYS_TRUE = False

GEOTARGETING_EXCLUDE_PREFIXES = ('/api/', '/admin/', '/export/', '/-/', '/jsi18n/')
GEOTARGETING_INCLUDE_PREFIXES = ('/api/tickets/redirect/', '/api/suburban/next_trains/')

LANGDETECTSERVER_URL = 'http://localhost:8111/'

SUPPORTED_HOSTS = []

BLACKBOX_PROJECT_FIELDS = []

# функция check_language почему-то ищет не в той директории .mo файлы,
# поэтому добавляем путь, где они реально лежат в virtualenv
LOCALE_PATHS = [os.path.join(os.path.dirname(__file__), '..', 'virtualenv', 'django', 'conf', 'locale')]

USE_X_FORWARDED_HOST = True

LOAD_DB_BASE_URL = 'https://work.admin.rasp.yandex-team.ru/admin/files/'
LOAD_DB_EXCLUDE_TABLES = ('importinfo_originalthreaddata',)
