PY23_LIBRARY()
OWNER(g:rasp-back)

PEERDIR(
    contrib/python/future
    contrib/python/freezegun
    contrib/python/httpretty
    contrib/python/ipython  # for tests debug with --pdb
    contrib/python/mock
    contrib/python/PyHamcrest
    contrib/python/pytest
    contrib/python/contextlib2

    travel/rasp/library/python/common23/date
    travel/rasp/library/python/common23/db
    travel/rasp/library/python/common23/settings
    travel/rasp/library/python/common23/utils
)

PY_SRCS(
    __init__.py
    hacks.py
    initializer.py
    matchers.py
    mocks.py
    settings.py
    skippers.py
    testcase.py
    transaction_context.py
    yaml_fixtures.py
    yaml_serializer.py

    helpers/assertions.py
    helpers/caplog.py
    helpers/class_counter.py
    helpers/mask_description.py

    management/__init__.py
    management/commands/__init__.py
    management/commands/flush.py
    management/commands/loadraspinitialdata.py

    plugins/http.py
    plugins/rasp_deprecation.py
    plugins/transaction.py
    plugins/translation.py

    utils/datetime.py
    utils/django_cache.py
    utils/django_databases.py
    utils/hamcrest.py
    utils/language_activator.py
    utils/logging.py
    utils/replace_dynamic_setting.py
    utils/replace_setting.py
    utils/request.py
)

END()

RECURSE(
    dummy_settings
    factories
    full_settings
    plugins_models
)

RECURSE_FOR_TESTS(
    tests
)
