# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import decorator


class ContextManagerAsDecorator(object):
    """
    A mixin which allows context manager to behave like decorator.

    class MyManager(ContextManagerAsDecorator):
        def __enter__(self):
            pass

        def __exit__(self, exc_type, exc_val, exc_tb):
            pass

    with MyManager():
        pass

    @MyManager()
    def foo():
        pass

    """

    def __call__(self, func, *args, **kwargs):
        def wrapper(func, *args, **kwargs):
            with self:
                return func(*args, **kwargs)

        return decorator.decorate(func, wrapper)
