# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import time

from six.moves.urllib.request import urlopen as standard_urlopen

from travel.rasp.library.python.common23.utils import tracer


log = logging.getLogger(__name__)


@tracer.wrap
def urlopen(*args, **kwargs):
    if 'timeout' not in kwargs:
        # Импортируем здесь, чтобы можно было использовать функцию без инициализации джанги
        from django.conf import settings
        kwargs['timeout'] = settings.HTTP_TIMEOUT

    start = time.time()

    try:
        return standard_urlopen(*args, **kwargs)
    finally:
        duration = time.time() - start

        try:
            log.debug('%.2f ms: urlopen(*%r, **%r)' % (duration * 1000, args, kwargs))
        except Exception:
            pass


def quick_urlopen(*args, **kwargs):
    from django.conf import settings

    kwargs['timeout'] = settings.QUICK_HTTP_TIMEOUT

    return urlopen(*args, **kwargs)
