# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from builtins import zip
from collections import namedtuple

from django.utils.encoding import force_str


def namedtuple_with_defaults(typename, field_names, defaults=None, **kwargs):
    """
    Создает класс, унаследованный от namedtuple. При создании экземпляра этого класса,
    поля, для которых значения не указаны, будут заполнены значениями из defaults.

    Пример:
        Record = namedtuple_with_defaults('Record', ['foo', 'bar'], defaults={'foo': 'qux'})

    :param typename: имя типа
    :param field_names: список полей
    :param defaults: словарь со значениями по умолчанию
    :param kwargs:
    :return: Класс
    """

    if defaults is None:
        defaults = {}

    named_tuple_class = namedtuple(typename, field_names, **kwargs)

    def new_method(cls, *args, **kwargs):
        for arg, fname in zip(args, cls._fields):
            if fname in kwargs:
                raise Exception('Duplicate field name {}'.format(fname))
            kwargs[fname] = arg
        for f in cls._fields:
            kwargs.setdefault(f, cls._defaults.get(f))
        return super(result_class, cls).__new__(cls, **kwargs)

    result_class = type(force_str(typename), (named_tuple_class,), {
        '_defaults': defaults,
        '__new__': new_method
    })

    return result_class
