# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import time


DC_PRIORITY = {
    'man': ['man', 'iva', 'myt', 'vla', 'sas'],
    'iva': ['iva', 'myt', 'vla', 'sas', 'man'],
    'myt': ['myt', 'iva', 'vla', 'sas', 'man'],
    'sas': ['sas', 'vla', 'myt', 'iva', 'man'],
    'vla': ['vla', 'sas', 'myt', 'iva', 'man'],
    None:  ['sas', 'vla', 'myt', 'iva', 'man'],
}


_no_priority = object()


def get_dc_priority(from_dc, to_dc, default_value=_no_priority):
    try:
        return DC_PRIORITY[from_dc].index(to_dc)
    except (KeyError, ValueError):
        if default_value is _no_priority:
            raise
        return default_value


class TimeInterval(dict):
    def __init__(self, dt, *args, **kwargs):
        super(TimeInterval, self).__init__(*args, **kwargs)
        self.dt = dt
        self.start_time = None
        self.reset()

    @property
    def is_time_passed(self):
        return self.get_current_time() - self.start_time >= self.dt

    def reset(self):
        self.start_time = self.get_current_time()

    def get_current_time(self):
        return time.time()
