from __future__ import unicode_literals

from gunicorn.app.base import Application
from six import iteritems


class GunicornApplication(Application):
    def __init__(self, app, options=None):
        self.options = options or {}
        self.application = app
        super().__init__()

    def load_config(self):
        config = dict([(key, value) for key, value in iteritems(self.options)
                       if key in self.cfg.settings and value is not None])
        for key, value in iteritems(config):
            self.cfg.set(key.lower(), value)

    def load(self):
        return self.application


def run_gunicorn(app, options):
    GunicornApplication(app, options).run()
