import json
import ssl

from aiohttp import client

from travel.library.python.aioapp.utils import request_var

DEFAULT_CA_FILE = '/usr/local/share/ca-certificates/YandexInternalRootCA.crt'


class ApiError(Exception):
    def __init__(self, url, status, message):
        self._url = url
        self.status = status
        self.message = message

    def __repr__(self):
        return json.dumps({
            'type': self.__class__.__name__,
            'url': str(self._url),
            'status': self.status,
            'message': self.message
        })


class BaseClient:
    def __init__(self, log, endpoint, cafile=DEFAULT_CA_FILE):
        self._log = log
        self._endpoint = endpoint
        self._sslcontext = ssl.create_default_context(cafile=cafile)

    @staticmethod
    def _create_context_headers():
        context = request_var.get()
        headers = {}

        if 'request_id' in context:
            headers['X-Request-Id'] = context['request_id']
        if 'trace_id' in context:
            headers['X-Trace-Id'] = context['trace_id']
        return headers

    async def _get(self, url, params):
        async with client.ClientSession() as session:
            async with session.get(
                url,
                params=params,
                ssl=self._sslcontext,
                headers=self._create_context_headers()
            ) as response:
                self._log.debug(response.real_url)
                result = await response.json()
                response.raise_for_status()
                return result, response
