#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import absolute_import

import numpy as np


INT_PRECISION = 10 ** 11
FLOAT_PRECISION = float(INT_PRECISION)


def simplify_and_encode_polyline(points):
    """Упрощение ломанных и добавление LOD"""

    max_zoom = 16

    epsilon_pix = 2  # минимальный размер отклонения в пикселях

    # минимальный размер отклонения в градусах
    epsilon = 180.0 / (256 * 2 ** max_zoom) * epsilon_pix

    anchor = 0
    floater = len(points) - 1
    stack = []

    # Расстояния по умолчанию равны 0
    distances = np.zeros(len(points))

    stack.append((anchor, floater))

    while stack:
        anchor, floater = stack.pop()

        if anchor + 1 >= floater:
            continue

        anchor_pt, floater_pt = points[anchor], points[floater]

        if (anchor_pt != floater_pt).any():
            anchor_vector = floater_pt - anchor_pt

            anchor_vector = anchor_vector / np.linalg.norm(anchor_vector)
        else:
            anchor_vector = np.array([0, 0])

        segment_points = points[anchor + 1:floater]

        # Векторы от начала отрезка до точек
        anchor_point_vectors = segment_points - anchor_pt

        # Векторы от конца отрезка до точек
        floater_point_vectors = segment_points - floater_pt

        # Расстояния от точек до прямой отрезка
        segment_distances = np.abs(np.cross(anchor_point_vectors, anchor_vector))

        # Проекции точек на отрезок
        anchor_projections = np.dot(anchor_point_vectors, anchor_vector)

        # Точки, проекция которых выходит за начало отрезка
        left_points = np.where(anchor_projections < 0)

        segment_distances[left_points] = np.linalg.norm(anchor_point_vectors[left_points])

        # Со стороны поплавка вектор якоря смотрит в обратную сторону
        floater_projections = np.dot(floater_point_vectors, -anchor_vector)

        # Точки, проекция которых выходи за конец отрезка
        right_points = np.where(floater_projections < 0)

        segment_distances[right_points] = np.linalg.norm(floater_point_vectors[right_points])

        # Самая дальняя точка
        segment_farthest = segment_distances.argmax()
        max_dist = segment_distances[segment_farthest]

        farthest = anchor + 1 + segment_farthest

        # Если максимальное расстояние больше чем эпсилон, разбиваем отрезок на два
        # и продолжаем рекрусивно
        if max_dist > epsilon:
            distances[farthest] = max_dist
            stack.append((anchor, farthest))
            stack.append((farthest, floater))

    levels = []

    distances[[0, -1]] = np.inf  # Начало и конец кривой всегда важны

    # Выбираем точки, которые остаются
    indices = np.where(distances > epsilon)

    important_points = points[indices]
    distances = distances[indices]

    levels = np.log2(distances / epsilon).clip(0, max_zoom)  # Бинарные уровни

    chr_base = ord('A') + max_zoom

    return encode_polyline(important_points), "".join(chr(chr_base - int(n)) for n in levels)


def encode_polyline(points):
    """Кодирование ломанных в бинарный формат Я.Карт"""
    return (np.vstack((points[:1], np.diff(points, axis=0))) * INT_PRECISION).astype('<i8').tostring('C')
