# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('www', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='Flight',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('departure', models.IntegerField()),
                ('arrival', models.IntegerField()),
                ('lng', models.FloatField()),
                ('lat', models.FloatField()),
                ('zoom', models.IntegerField()),
                ('number', models.CharField(max_length=100)),
                ('route_uid', models.CharField(max_length=100, null=True)),
                ('title', models.CharField(max_length=100)),
                ('thread_uid', models.CharField(max_length=100, null=True)),
                ('company_title', models.CharField(max_length=100, null=True)),
                ('t_code', models.CharField(max_length=10)),
                ('station_from', models.ForeignKey(related_name='departed_flights', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='arriving_flights', to='www.Station')),
            ],
        ),
        migrations.CreateModel(
            name='LiveBus',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('data', models.TextField()),
                ('lng', models.FloatField(db_index=True)),
                ('lat', models.FloatField(db_index=True)),
                ('departure', models.DateTimeField(db_index=True)),
                ('arrival', models.DateTimeField(db_index=True)),
                ('thread', models.ForeignKey(to='www.RThread')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Train',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('data', models.TextField()),
                ('lng', models.FloatField(db_index=True)),
                ('lat', models.FloatField(db_index=True)),
                ('departure', models.DateTimeField(db_index=True)),
                ('arrival', models.DateTimeField(db_index=True)),
                ('thread', models.ForeignKey(to='www.RThread')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterIndexTogether(
            name='flight',
            index_together=set([('zoom', 'lng', 'lat')]),
        ),
    ]
