# -*- coding: utf-8 -*-

import numpy as np


def interpolate_coords(t, times, coords):
    i = np.searchsorted(times, t, side='left')

    # Меньше первого времени или совпадает с ним
    if i == 0:
        # Возвращаем первое положение
        return coords[i]

    # Больше последнего времени
    if i == len(times):
        return coords[-1]

    # Если время совпало, возвращаем координату в этой точке
    if times[i] == t:
        return coords[i]

    # Иначе интерполируем по отрезку
    c0, c1 = coords[[i - 1, i]]

    t0, t1 = times[[i - 1, i]]

    return c0 + (c1 - c0) * ((t - t0) / (t1 - t0))
