# -*- coding: utf-8 -*-

import math


class Sieve(object):
    PIXEL_STEP = 50  # Шаг сетки в пикселях
    MAX_ZOOM = 17  # Крупнее этого уровня отображать все объекты

    def __init__(self, zoom):
        if zoom >= self.MAX_ZOOM:
            self.cells = None
        else:
            self.cells = set()  # Ячейки для просеивания

            pixel_size = 360.0 / 2 ** zoom / 256  # размер пикселя в градусах
            self.cell_size = pixel_size * self.PIXEL_STEP

    def fit(self, live_object):
        if self.cells is None:
            return True

        key = (int(math.floor(live_object.lng / self.cell_size)),
               int(math.floor(live_object.lat / self.cell_size)))

        if key in self.cells:
            return False

        self.cells.add(key)

        return True
