from aiohttp import ClientResponseError

from travel.rasp.library.python.httpclient.async_client import BaseClient, ApiError


class MordaBackendError(ApiError):
    pass


class MordaBackendClient(BaseClient):
    async def get_transfers(self, point_from, point_to, when, transport_types, language):
        params = [
            ('pointFrom', point_from),
            ('pointTo', point_to),
            ('when', when.strftime('%Y-%m-%d')),
            ('pricesOn', 'false'),
        ]
        for ttype in transport_types:
            params.append(('transportType', ttype))

        url = '{}/{}/{}'.format(self._endpoint, language, 'search/transfers/')
        try:
            result, response = await self._get(url, params)
        except ClientResponseError as ex:
            self._log.exception('Morda backend client exception')
            raise MordaBackendError(ex.request_info.real_url, ex.status, ex.message) from ex
        except Exception as ex:
            self._log.exception('Morda backend client exception')
            raise MordaBackendError(url, None, None) from ex
        if 'errors' in result:
            self._log.exception('Morda backend client exception')
            raise MordaBackendError(response.real_url, response.status, result['errors'])

        return result.get('transferVariants', [])
