# coding: utf8

from __future__ import absolute_import, division, print_function, unicode_literals

from six.moves.urllib.parse import urlparse

FTP_PORT = 8021
HTTP_PORT = 80


class FtpProxy(object):
    def __init__(self, url, user, password):
        self.url = url
        self.user = user
        self.password = password


class HttpProxy(dict):
    def __init__(self, url):
        super(HttpProxy, self).__init__()
        self.url = url
        self['http'] = url
        self['https'] = url


class ProxyPool(object):
    def __init__(self, user, password):
        self.user = user
        self.password = password

    def get_hosts(self):
        raise NotImplementedError()

    def get_ftp_proxies(self, ftp_url, ftp_user=None, ftp_password=None):
        proxies = []

        url = urlparse(ftp_url)
        ftp_user = ftp_user or url.username
        ftp_password = ftp_password or url.password

        for proxy_host in self.get_hosts():
            # https://3proxy.ru/howtor.asp#FTP
            username = ':'.join((self.user, self.password, ftp_user) if ftp_user else (self.user, self.password))
            server = '{}:{}'.format(url.hostname, url.port or 21)

            proxy = FtpProxy(
                url=url._replace(netloc="{}:{}".format(proxy_host, FTP_PORT)).geturl(),
                user='{}@{}'.format(username, server),
                password=ftp_password
            )

            proxies.append(proxy)

        return proxies

    def get_http_proxies(self):
        proxies = []

        for proxy_host in self.get_hosts():
            url = 'http://{user}:{pwd}@{host}:{port}'.format(
                user=self.user,
                pwd=self.password,
                host=proxy_host,
                port=HTTP_PORT
            )

            proxies.append(HttpProxy(url))

        return proxies
