# coding: utf8

from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from retry import retry

from travel.rasp.library.python.proxy.proxy_pool import ProxyPool
from travel.library.python.yp.endpoints import YpEndpoints


log = logging.getLogger(__name__)


class YpProxyPool(ProxyPool):
    def __init__(self, user, password, yd_entry_point, client_name='rasp_proxy_pool',
                 current_dc='sas', fallback_hosts=None):

        super(YpProxyPool, self).__init__(user, password)
        self.yd_entry_point = yd_entry_point
        self.client_name = client_name
        self.current_dc = current_dc
        self.fallback_hosts = sorted(fallback_hosts, key=self.hosts_sort_key_func) if fallback_hosts else []

    def hosts_sort_key_func(self, host):
        return self.current_dc.lower() not in host.lower().split('.')

    def get_hosts(self):
        try:
            hosts = self.get_hosts_from_yp()
        except Exception as ex:
            log.error('Failed to discover YpEndpoints. fallback_hosts={} {}'.format(self.fallback_hosts, repr(ex)))
            return self.fallback_hosts

        if not hosts:
            return self.fallback_hosts

        return sorted(hosts, key=self.hosts_sort_key_func)

    @retry(tries=2, delay=5)
    def get_hosts_from_yp(self):
        return YpEndpoints(self.client_name, self.yd_entry_point).get_hosts()
