# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import re

from route_search.by_number.helpers import build_t_type_ids_list, get_search_result, old_sub_find_threads
from route_search.by_number.models import ThreadSearchResult  # noqa


def find_threads_by_query(query, t_type_ids=None):
    """
    Ищем нитки по номеру, или специальному названию

    :param query: запрос (номер или специальное название)
    :param t_type_ids: список id типов транспорта для поиска.
                       Пустой список или None означают искать по всем типам транспорта
    :rtype: ThreadSearchResult
    """

    t_type_ids = build_t_type_ids_list(t_type_ids)

    query = query.strip()
    result = get_search_result(query, t_type_ids)

    if not result.routes:
        new_query = get_cleaned_plane_number(query)

        if new_query and new_query != query:
            result = get_search_result(new_query, t_type_ids)

    return result


# Код может состоять из букв и цифр, но если он длиной 3, то
# 3-тий символ это буква,
# Так же предполагаем что двух цифр подряд в коде быть не может. Хотя это спорный момент.
PLANE_NUMBER_RE = re.compile(r'''^
    (?P<code>(?:[a-zа-яё][0-9]|[0-9][a-zа-яё]|[a-zа-яё]{2})[a-zа-яё]?)
    (?P<delimiter>[\s\W]*)  # разделитель
    (?P<flight_number>\d+)
$''', re.U + re.I + re.VERBOSE)


def get_cleaned_plane_number(number):
    match = PLANE_NUMBER_RE.match(number)
    if match:
        parts = match.groupdict()
        return parts['code'] + u' ' + parts['flight_number'].lstrip(u'0')


def old_find_threads(query):
    threads = old_sub_find_threads(query)

    if threads:
        return threads

    # Расклеиваем самолетный номер, и убираем нули в flight_number SU01 -> SU 1
    if 3 <= len(query) <= 10:
        number = query[:2] + u' ' + query[2:]
        number = re.sub(r'(^|\D)0+(\d)', lambda res: res.group(1) + res.group(2), number)

        threads = old_sub_find_threads(number)

    return threads
