# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from xml.etree import cElementTree as ET

from common.tester.factories import create_thread, create_station
from travel.rasp.library.python.common23.date import environment
from route_search.transfers.fill_from_rasp_db import fill_rasp_db_segments, fetch_stations
from route_search.transfers.variant import Variant


def create_transfer_variant(routes=None, **kwargs):
    if not routes:
        routes = [{}]  # у варианта должен быть хотя бы один роут

    default_variant_kwargs = {}
    default_route_kwargs = {
        'departure_datetime': '2017-11-12 13:14',
        'arrival_datetime': '2017-11-12 13:14',
        'start_date': '2017-11-12',
    }

    variant = ET.Element('variant')
    default_variant_kwargs.update(kwargs)
    for k, v in default_variant_kwargs.items():
        variant.set(k, v)

    for route_kwargs in routes:
        route = ET.SubElement(variant, 'route')

        thread = route_kwargs.pop('thread', None)
        station_from = route_kwargs.pop('station_from', None)
        station_to = route_kwargs.pop('station_to', None)

        if not thread and not station_from and not station_to:
            station_from, station_to = create_station(), create_station()
            thread = create_thread(schedule_v1=[
                [None, 0, station_from],
                [10, None, station_to],
            ])

        route_kwargs['thread_id'] = thread.uid
        route_kwargs['departure_station_id'] = station_from.id
        route_kwargs['arrival_station_id'] = station_to.id

        default_route_kwargs.update(route_kwargs)
        route.attrib.update(default_route_kwargs)

    variant = Variant(variant)
    valid_pathfinder_segments = fetch_stations(variant.pathfinder_segments)
    fill_rasp_db_segments(valid_pathfinder_segments, environment.now_aware())
    variant.make_segments_and_transfers()

    return variant
