# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.db import models
from django.utils.translation import ugettext_lazy as _


log = logging.getLogger(__name__)


class BaseZNodeRoute2(models.Model):
    """
    Поисковый индекс точка-точка.
    """

    route = models.ForeignKey('www.Route')
    thread = models.ForeignKey('www.RThread')
    t_type = models.ForeignKey('www.TransportType',  verbose_name=_('Тип транспорта'), null=False)

    settlement_from = models.ForeignKey('www.Settlement', related_name='%(app_label)s_outgoing_noderoutes2', null=True)
    station_from = models.ForeignKey('www.Station', related_name='%(app_label)s_outgoing_noderoutes2')
    rtstation_from = models.ForeignKey('www.RTStation', related_name='%(app_label)s_outgoing_noderoutes2', null=True)

    settlement_to = models.ForeignKey('www.Settlement', related_name='%(app_label)s_incoming_noderoutes2', null=True)
    station_to = models.ForeignKey('www.Station', related_name='%(app_label)s_incoming_noderoutes2')
    rtstation_to = models.ForeignKey('www.RTStation', related_name='%(app_label)s_incoming_noderoutes2', null=True)

    stops_translations = models.TextField(null=False, default='')

    good_for_start = models.BooleanField(
        null=False, default=True, verbose_name=_('Этот сегмент можно использовать при поиске из города settlement_from')
    )
    good_for_finish = models.BooleanField(
        null=False, default=True, verbose_name=_('Этот сегмент можно использовать при поиске до города settlement_to')
    )

    class Meta:
        app_label = 'www'
        index_together = [
            ['settlement_from', 'settlement_to'],
            ['settlement_from', 'station_to'],
            ['station_from', 'settlement_to'],
            ['station_from', 'station_to'],
        ]
        abstract = True
