# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from route_search.transfers.variant import Variant


class Group(object):
    """Группа маршрутов с пересадками"""
    def __init__(self, element):
        self.variants = [Variant(variant_element) for variant_element in element.findall('variant')]

    @property
    def best_variant(self):
        return self.variants[0]

    @property
    def first_arrival(self):
        return min(v.arrival for v in self.variants)

    @property
    def last_arrival(self):
        return max(v.arrival for v in self.variants)

    def __repr__(self):
        return '<Group ' + " ".join([
            "best_time=%r" % self.best_variant.duration,
            "departure=%r" % self.best_variant.departure,
            "first_arrival=%r" % self.first_arrival,
            "last_arrival=%r" % self.last_arrival,
            "has %d variants" % len(self.variants),
        ]) + '>'
