# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import time as time_module
from datetime import datetime, date
from dateutil import parser

from common.data_api.baris.helpers import BarisPseudoUid
from common.utils.date import MSK_TZ

# Эта дата используется в Пересадочнике как начало отсчета для многих вычислений.
# Для нас это покзатель ошибки, т.к. данных за 2008 год у нас нет.
# https://github.yandex-team.ru/rasp/pathfinder/blob/26dce3bb7b8b0e0324dc3c8299cd239750dd1a9e/pathfinderlib/pf.h#L62
PATHFINDER_ERROR_DATE = date(2008, 1, 1)


class PathfinderSegment(object):
    """
    Сегмент, возвращаемый пересадочником
    """
    def __init__(self, element):
        self.thread_uid = element.get('thread_id')

        baris_pseudo_uid = BarisPseudoUid(self.thread_uid)
        self.is_baris_segment = baris_pseudo_uid.is_baris_flight
        self.flight_number = baris_pseudo_uid.flight_number

        self.msk_departure = self._parse_datetime(element.get('departure_datetime'))
        self.msk_arrival = self._parse_datetime(element.get('arrival_datetime'))
        self.msk_start_date = parser.parse(element.get('start_date')).date()

        self.station_from = None
        self.station_from_id = int(element.get('departure_station_id'))
        self.station_to = None
        self.station_to_id = int(element.get('arrival_station_id'))

        self.convenience = get_element_convenience(element)
        self.transfer_segment = None

    def _parse_datetime(self, str):
        return MSK_TZ.localize(datetime(*time_module.strptime(str, '%Y-%m-%d %H:%M')[:6]))

    @property
    def is_valid(self):
        return (
            self.station_from is not None and
            self.station_to is not None and
            self.msk_arrival is not None and
            self.msk_departure is not None and

            # RASPAPI-392
            self.msk_arrival.date() != PATHFINDER_ERROR_DATE and
            self.msk_departure.date() != PATHFINDER_ERROR_DATE
        )


def get_element_convenience(element):
    try:
        convenience = element.get('tr')
        if convenience == '':
            return None
        return int(convenience)
    except Exception:
        return None
