#!/usr/bin/env python
# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
from subprocess import check_call

try:
    from tempfile import TemporaryDirectory
except ImportError:
    from backports.tempfile import TemporaryDirectory


def check_sitemaps(index_filepath, sitemap_filepaths):
    with TemporaryDirectory('xsd') as tmpdir:
        sitemap_xsd = os.path.join(tmpdir, 'sitemap.xsd')
        siteindex_xsd = os.path.join(tmpdir, 'siteindex.xsd')

        with open('/dev/null', 'w') as dev_null:
            check_call(['wget', '-O', sitemap_xsd, 'http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd'],
                       stdout=dev_null, stderr=dev_null)
            check_call(['wget', '-O', siteindex_xsd, 'http://www.sitemaps.org/schemas/sitemap/0.9/siteindex.xsd'],
                       stdout=dev_null, stderr=dev_null)

        check_call(['xmllint', '--noout', '--schema', siteindex_xsd, index_filepath])

        for sitemap_filepath in sitemap_filepaths:
            check_call(['xmllint', '--noout', '--schema', sitemap_xsd, sitemap_filepath])
