# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

import boto3
from botocore.client import Config


log = logging.getLogger(__name__)


class SQSClientWrapper(object):
    def __init__(self, aws_access_key_id, aws_secret_access_key, aws_session_token, endpoint_url,
                 connect_timeout=1, read_timeout=10, retries=1, enable_writing=True):

        self.enable_writing = enable_writing

        session = boto3.session.Session(
            aws_access_key_id=aws_access_key_id,
            aws_secret_access_key=aws_secret_access_key,
            aws_session_token=aws_session_token
        )

        self._client = session.client(
            service_name='sqs',
            endpoint_url=endpoint_url,
            config=Config(
                connect_timeout=connect_timeout,
                read_timeout=read_timeout,
                retries={'max_attempts': retries}
            ),
        )

    def send_message(self, *args, **kwargs):
        if not self.enable_writing:
            log.warn('Writing to SQS is not allowed')
            return

        return self._client.send_message(*args, **kwargs)

    def __getattr__(self, name):
        if name == 'send_message':
            return self.send_message

        return getattr(self._client, name)
