# -*- coding: utf-8 -*-

from datetime import datetime

from stationschedule.type import AbstractSchedule
from stationschedule.utils import TIMEDELTA_ONE_DAY, TIME_FOUR_HOURS


class TrainSchedule(AbstractSchedule):
    def __init__(self, station, **kwargs):
        super(TrainSchedule, self).__init__(station, **kwargs)

    def _default_end_datetime_limit(self, schedule_date):
        # Если расписание на конкретную дату, то выводим по 04:00 следующего дня
        return datetime.combine(schedule_date + TIMEDELTA_ONE_DAY, TIME_FOUR_HOURS)
