from aiohttp import ClientResponseError

from travel.rasp.library.python.httpclient.async_client import BaseClient, ApiError

DEFAULT_NATIONAL = 'ru'


class TicketDaemonError(ApiError):
    pass


class TicketDaemonClient(BaseClient):
    async def get_prices(self, station_from, station_to, departure_dt, poll=True,
                         tld=DEFAULT_NATIONAL, language='ru', include_interlines=False, asker=None):
        if poll:
            url = '{}/{}'.format(self._endpoint, 'jsendapi/rasp/results_by_search_params/')
        else:
            url = '{}/{}'.format(self._endpoint, 'jsendapi/init_search/')
        params = [
            ('lang', language),
            ('t_code', 'plane'),
            ('service', 'rasp_morda_backend'),
            ('national', tld),
            ('date_forward', departure_dt.strftime('%Y-%m-%d')),
            ('point_from', station_from),
            ('point_to', station_to)
        ]
        if include_interlines:
            params.append(('full_results', 1))

        try:
            result, response = await self._get(url, params=params)
            if response.status == 204:
                raise TicketDaemonError(response.url, response.status, "Ticket daemon no content")
        except ClientResponseError as ex:
            self._log.exception('Ticket daemon client exception')
            raise TicketDaemonError(ex.request_info.real_url, ex.status, ex.message) from ex

        return result
