# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from travel.library.python.tracing.sampling import Config


def build_jaeger_config(service_name):
    jaeger_sampler_type = os.environ.get('JAEGER_SAMPLER_TYPE', 'probabilistic')
    jaeger_sampler_parameter = float(os.environ.get('JAEGER_SAMPLER_PARAMETER', 0.001))
    jaeger_config = Config(
        config={
            'sampler': {
                'type': jaeger_sampler_type,
                'param': jaeger_sampler_parameter,
            },
            'logging': True,
        },
        service_name=service_name,
        validate=True,
    )
    return jaeger_config
