from datetime import timedelta

from aiohttp import ClientResponseError

from travel.rasp.library.python.httpclient.async_client import BaseClient, ApiError

DEFAULT_PARTNER = 'im'
DEFAULT_NATIONAL = 'ru'
DATETIME_FORMAT = '%Y-%m-%dT%H:%M:%S+00:00'


class TrainApiError(ApiError):
    pass


class TrainApiClient(BaseClient):
    async def get_prices(
        self, station_from, station_to, departure_dt, poll=True, tld=DEFAULT_NATIONAL, language='ru', asker=None,
        include_price_fee=False, icookie=None
    ):
        url = '{}/{}/{}'.format(self._endpoint, language, 'api/segments/train-tariffs/')
        if poll:
            url = '{}{}'.format(url, 'poll/')
        params = [
            ('pointFrom', station_from),
            ('pointTo', station_to),
            ('startTime', departure_dt.strftime(DATETIME_FORMAT)),
            ('endTime', (departure_dt+timedelta(days=1, hours=4)).strftime(DATETIME_FORMAT)),
            ('national_version', tld),
            ('partner', DEFAULT_PARTNER),
            ('useWizardSource', 1)
        ]
        if asker is not None:
            params.append(('asker', asker))
        if include_price_fee:
            params.append(('includePriceFee', 1))
        if icookie:
            params.append(('icookie', icookie))

        try:
            result, response = await self._get(url, params)
        except ClientResponseError as ex:
            self._log.exception('Train api client exception')
            raise TrainApiError(ex.request_info.real_url, ex.status, ex.message) from ex

        return result
