from aiohttp import ClientResponseError

from travel.rasp.library.python.httpclient.async_client import BaseClient, ApiError


class TrainWizardApiError(ApiError):
    pass


class TrainWizardApiClient(BaseClient):
    async def get_prices_by_directions(self, departure_points, arrival_points, departure_date_from, departure_date_to,
                                       tld):
        url = '{}/{}'.format(self._endpoint, 'searcher/public-api/prices_by_directions/')
        params = [
            ('tld', tld),
            ('departure_date_from', departure_date_from.strftime('%Y-%m-%dT%H:%M')),
            ('departure_date_to', departure_date_to.strftime('%Y-%m-%dT%H:%M')),
        ]
        for dp in departure_points:
            params.append(('departure_points', dp))
        for ap in arrival_points:
            params.append(('arrival_points', ap))

        try:
            result, response = await self._get(url, params)
        except ClientResponseError as ex:
            self._log.exception('Train wizard api client exception')
            raise TrainWizardApiError(ex.request_info.real_url, ex.status, ex.message) from ex
        if response.status == 204:
            return []

        return result
