# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from urlparse import SplitResult

from ..errors import UrlMappingError
from ..utils import parse_url


class BaseToMapper(object):

    def __init__(self, domain, schema='https'):
        self.domain = domain
        self.schema = schema

    def build_url(self, path, params=None):
        if params:
            query = params.urlencode()

        else:
            query = ''

        return SplitResult(self.schema, self.domain, path, query, '').geturl()

    def map_url_to(self, url):
        raise NotImplementedError


class DeclarativeMapper(object):

    def __init__(self):
        self.mapping = []

    def map_url_to(self, url, *args, **kwargs):
        base_mapper = BaseToMapper(*args, **kwargs)
        path, params = parse_url(url)

        mapper = next(
            (mapper
                for prefix, mapper in self.mapping
                if path.startswith(prefix)),
            None
        )

        if mapper is None:
            raise UrlMappingError('No mapping for path %s' % path)

        return base_mapper.build_url(*mapper(path, params))

    def map_prefix(self, prefix):
        def decorator(func):
            self.mapping.append((prefix, func))
            return func

        return decorator
