from common.settings.configuration import BaseConfigurator, Configuration

RASP_DOMAINS = {
    'rasp': {
        'ru': 'rasp.yandex.ru',
        'ua': 'rasp.yandex.ua',
    },
    'touch': {
        'ru': 't.rasp.yandex.ru',
        'ua': 't.rasp.yandex.ua',
    }
}

RASP_ALTVERSIONS = {
    'rasp': {},
    'touch': {
        'attrs': {
            'rel': 'alternate',
            'media': 'only screen and (max-width: 640px)',
        }
    }
}


class UrlMapperConfigurator(BaseConfigurator):
    def apply_testing(self, settings):
        settings['RASP_DOMAINS'] = {
            'rasp': {
                'ru': 'rasp.tst.rasp.yandex.ru',
                'ua': 'rasp.tst.rasp.yandex.ua',
            },
            'touch': {
                'ru': 'testing.touch.rasp.common.yandex.ru',
                'ua': 'testing.touch.rasp.common.yandex.ua',
            }
        }


Configuration.configurator_classes.append(UrlMapperConfigurator)
