# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

import ydb


class BaseTable:
    PATH = None
    NAME = None

    def __init__(self, ydb_session_context):
        self.ydb_session_context = ydb_session_context

        database = ydb_session_context.driver_config.database

        self.full_path = os.path.join(database, self.PATH).rstrip('/')
        self.full_name = os.path.join(self.full_path, self.NAME)

    def execute(self, query, params=None):
        if params is None:
            params = {}

        def transaction(session):
            prepared_query = session.prepare(query)
            result_sets = session.transaction(ydb.SerializableReadWrite()).execute(
                prepared_query,
                parameters=params,
                commit_tx=True
            )
            return result_sets

        return self.ydb_session_context.session_pool.retry_operation_sync(transaction)

    def description(self):
        raise NotImplementedError('"description" method is not implemented')
