#!/usr/bin/env python2
# -*- coding: utf-8 -*-

import os
import re
import subprocess


MARKUP_SUBMODULE = 'morda/markup'
SUBMODULE_HASH_PATTERN = re.compile(r'[ +-](.+?) ')


def get_submodule_hash(submodule_path):
    submodule_status = subprocess.check_output(
        ['git', 'submodule', 'status', submodule_path]
    )

    match = SUBMODULE_HASH_PATTERN.match(submodule_status)

    assert match, "Invalid status of markup submodule: %r" % submodule_status

    return match.group(1)


def main():
    markup_hash = get_submodule_hash(MARKUP_SUBMODULE)
    tmp_markup = os.path.join('/tmp', 'markup')
    os.makedirs(tmp_markup)
    os.chdir(tmp_markup)
    list(map(subprocess.check_call, [
        ['git', 'init'],
        ['git', 'remote', 'add', 'origin', 'https://github.yandex-team.ru/rasp/morda_markup'],
        ['git', 'fetch', '--depth=1', 'origin', 'refs/tags/build-{}'.format(markup_hash)],
        ['git', 'checkout', 'FETCH_HEAD'],
        ['mv', '-T', os.path.join(tmp_markup, 'debian/markup-built'), '/app/morda/markup'],
        ['mv', os.path.join(tmp_markup, 'debian/markup-version'), '/app/morda/markup/'],
        ['rm', '-rf', tmp_markup]
    ]))


if __name__ == '__main__':
    main()
