# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from settings import *

import os
from common.settings.configuration import Configuration
from common.settings.utils import configure_raven, get_app_version
from travel.rasp.library.python.common23.logging.configure import configure_default_logging


PACKAGE_NAME = 'old-morda-qloud'

if os.getenv('USE_SERVICE_DB'):
    INSTANCE_ROLE = ServiceInstance


LOG_PATH = '/var/log/app/'


class MordaConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        self.setup_logging(settings)

    def apply_production(self, settings):
        configure_raven(settings, 'morda')

    def apply_testing(self, settings):
        configure_raven(settings, 'morda')

    def setup_logging(self, settings, base_log_level=None):
        settings['LOGGING'] = configure_default_logging(settings, base_log_level=base_log_level)


Configuration.configurator_classes += [MordaConfigurator]

Configuration().apply(globals())

PKG_VERSION = get_app_version()

CACHEROOT = '/%s/%s/' % (PACKAGE_NAME, PKG_VERSION)

admin_host = 'admin.rasp.yandex-team.ru'


ADMINS = (('Rasp Testing', 'rasp-testing@yandex-team.ru'), )

BASE_LOG_LEVEL = os.environ.get('RASP_BASE_LOG_LEVEL', 'INFO')

ENABLE_ANTIROBOT = True

MEDIA_URL = '//yastat.net/s3/rasp/media/'

TVM_DESTINATIONS = ['TVM_BLACKBOX', 'TVM_BLACKBOX_MIMINO']

if YANDEX_ENVIRONMENT_TYPE == 'production':
    TINYURL = 'http://tinyurl.yandex.net/tiny'
    SUGGEST_URL = '//suggests.rasp.yandex.net/'
    TICKETS_QUERY_URL = 'http://daemon.avia.yandex.net/api/1.0/'

    SUPPORTED_HOSTS = [
        'rasp.yandex.%s' % tld
        for tld in ['ru', 'ua', 'kz', 'uz', 'by']
    ] + ['rasp.ya.ru']

    ADMINS = (('Rasp Testing', 'rasp-errors@yandex-team.ru'), )

    TVM_SERVICE_ID = 2017309

elif YANDEX_ENVIRONMENT_TYPE == 'testing':
    admin_host = 'admin-test.rasp.yandex-team.ru'
    MEDIA_URL = '//work.%s/media/' % admin_host

    SUGGEST_URL = '//testing.suggests.rasp.common.yandex.net/'
    DOMAIN_NAME = 'testing.old-morda-python.rasp.common.yandex.ru'

    DOMAIN_TO_TOUCH_NATIONAL_VERSION = {
        'ru': 'testing.touch.rasp.common.yandex.ru'
    }

    TOUCH_DOMAIN = DOMAIN_TO_TOUCH_NATIONAL_VERSION['ru']

    SUPPORTED_HOSTS = [
        'testing.old-morda-python.rasp.common.yandex.ru'
    ]

    TVM_SERVICE_ID = 2017307
    TVM_BLACKBOX = 239

elif YANDEX_ENVIRONMENT_TYPE == 'stress':
    emulator_host = 'target152g.load.yandex.net'

    # Настройки тарифов
    ASK_UFS = True
    UFS_HOST = emulator_host + ':8080'
    UFS_TRAINLIST = '/ufs/trainlist'
    UFS_CARSLISTEX = '/ufs/carslistex'
    UFS_SSL = False
    ASK_TICKETS_UA = True
    TICKETS_UA_TRAIN_URL = 'http://%s:8080/tickets_ua' % emulator_host
    UFS_PLANE_URL = "http://%s:8080/ufs" % emulator_host
    UKRMINTRANS_HOST = "http://%s:8080/ukrmintrans" % emulator_host

    TINYURL = 'http://%s/tinyurl.xml' % emulator_host

    ENABLE_ANTIROBOT = False

    SUGGEST_URL = '//testing.suggests.rasp.common.yandex.net/'

if YANDEX_ENVIRONMENT_TYPE in ['stress', 'testing']:
    if YANDEX_ENVIRONMENT_NAME == 'localhost':
        SUGGEST_URL = '//suggests.rasp.yandex.net/'

MEDIA_URL = os.getenv('RASP_MEDIA_URL', MEDIA_URL)
MEDIA_ROOT = '/data/media'
EXPORT_PATH = '/data/export'

GEOMETRY_BASE_PATH = os.environ.get('RASP_GEOMETRY_BASE_PATH', '/var/geometry/RESOURCE/lib/yandex-rasp-morda/geometry')

SEARCH_LOG = os.path.join(LOG_PATH, 'marketstat/search.log')
REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/redir.log')
PLANE_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/plane_redir.log')
BUS_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/bus_redir.log')
AUCTION_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/auction_redir.log')
RASP_USERS_SEARCH_LOG = os.path.join(LOG_PATH, 'yt/search.log')

LOGTAIL_AVAILABLE_LOGS = {
    'tariffs/express_subst.log': '/app/log/rasp/tariffs/express_subst.log',
    'tickets/unknown_codes.log': '/app/log/yandex-ticket-daemon/ticket_daemon/reference/unknown_codes.log',
}

MANAGERS = ADMINS
PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
ERRORS_RECIPIENTS = PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
EXPERSS_SUBST_RCPNTS = UNKNOWN_CODES_RCPNTS = RASP_FREE_STATIONS_RCPNTS = ADMINS
