import os

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "local_settings")

from travel.rasp.library.python.common23.server.gunicorn.default import *  # noqa
from travel.rasp.library.python.common23.server.gunicorn import default


def on_starting(server):
    default.on_starting(server)
    load_geometry()
    server.log.info('Geometry loaded')


def on_reload(server):
    default.on_reload(server)
    load_geometry()
    server.log.info('Geometry reloaded')


def load_geometry():
    from mapping.drawers import TrainPathDrawer, LimePathDrawer
    TrainPathDrawer.storage.preload()
    LimePathDrawer.storage.preload()
