import os
import codecs

from django.core.management.base import NoArgsCommand
from django.conf import settings

from common.utils.dateparser import generate_validator_js


class Command(NoArgsCommand):
    def handle_noargs(self, **options):
        with codecs.open(
            os.path.join(settings.PROJECT_PATH, 'morda/markup/blocks-desktop/i-time/date_validator.js'),
            'w',
            encoding='utf-8'
        ) as date_validator_js:
            date_validator_js.write(generate_validator_js())
